

 
/***********************************************************************************************
 *                                                                                             *
 *                     Example_2. ET-REMOTE MP3 COMMAND-Mode By Read Play Time                 *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *											                                                                *
 * Target MCU     : AT89C51RE2 (CP-JR51RE2 V1.0)                                               *
 * Editor         :  uvision3 3.62c                                                            *       
 * Compiler       : Keil C51 (V8.05 a)                                                         *
 *															                                   *
 * Port Interface :      																	   *
 *                                                                                             *
 *                : # MCU-89C51RE2#                 # ET-REMOTE MP3 V2 #                       *
 *                  ---------------                  --------------------                      *
 * UART0(RS232#1) :    P3.0(RX0)        Connect             Tx                                 *
 *                     P3.1(TX0)        Connect             Rx                                 *
 *                     GND              Connect             GND                                *
 *                     BAUD RATE 9600                                                          *  
 *              5V                                                                             *
 *             -+-                                                                             *
 *              |                                                                              *
 *              +------------------+                                                           *
 *              |                  |                                      -DIP SW.MODE         *
 *              |                  |                                       S1=ON ; S2=ON       *
 *              |                  |                 ET-REMOTE MP3 V2     -DIP SW.CONFIG       *
 *       +------+------+           |               +-------------------+   S1=ON ; S2=OFF      *
 *       |             |       +---+---+   +---+   |                   |   BR:9600             *
 *       |             |       |       |   |   |   |RS232(have-Max232) |                       *
 *       |             | RX0   |       |   |   |   |----+              |                       *
 *       |         P3.0+-------|RxI RxO|<--|-+ +-->|*Rx||              |        /|             *   
 *       |             | TX0   |       |   | |     |   ||              |      /  |             *
 *       |         P3.1+-------|TxI TxO|---+ +-----|*Tx||              +----||   |             *
 *       |             |       |       |           |   ||              |    || SP|             *
 *       |             |       |MAX232 |       +---+*G ||              +----||   |             *
 *       |             |       +---+---+       |   |----+   [Power]    |      \  |             *
 *       |   89C51RE2  |           |           |   |                   |        \|             * 
 *       +------+------+           |           |   |         G  5V     |                       *
 *              |                  |           |   +---------+---+-----+                       * 
 *              |                  |           |             |   |                             *
 *              +------------------+-----------+             |   +--->5V                       *
 *              |                                            |                                 *
 *            --+--                                        --+--                               *
 *             ---                                          ---                                *
 *              -                                            -                                 *
 *                                                                                             *
 * Test Operate    : For Test Program in Micro SD Card must have File Name 'A23_FT1.MP3' and   *
 *                   'A23_FT2.MP3' ;... Begin Set Command For Show play Time then Play File    *
 *                   Name 'A23_FT1.MP3' is time 30 sec. and chang play File Name               *
 *                   'A24_FT2.MP3' is time 1 minute ,Then Return play New first file           *
 *                                                                                             *
 * Last Update     : 6/June/2012                                                               *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/


 #include <at89c51xd2.h>
 #include <stdio.h>

 char Buf_Time[5]  ; 


 
/***********************************************
 *                  Function Delay 		       *
 ***********************************************/
 void delay(int cnt)
 {
  int i,j ;
  
      for(i=0;i<cnt;i++)
	    for(j=0;j<cnt;j++);
 }


 
 /********************************************
  *              Initial UART0               *
  ********************************************/

 void UART0_Init(void)
  {

   BDRCON |= 0x1C  ;  // Select Internal Baud-Rate,enable,0x1E=Fast //0x1C=No fast 	 
   SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
   ES      = 0     ;  //Disable Serial Uart  Interrupt    
  
   BRL     = 0x88  ;  // Baud Rate 9600
   PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   BDRCON |= 0x02  ;  // Set SPD  =1 :Fast BR  
  
  }


  
/*************************************************************************************
 **                 Check Respond Command From Board MP3                            **
 *************************************************************************************/

//-------------- Check Echo Command (#OK)----------------

void Echo_Cmm()
 {
   char buf_cmm[2] ;
   char n,ch ;
   
   do
    {
      do
       {
         while(RI==0){;}                  //Check Flag Rx if RI =1 Have data
         ch = SBUF 				        ; //Read Data
		 RI = 0                         ; //Clear Flag Rx
       }while(ch != '#')                ; //Check Byte Start of Echo cmm('#')

      for(n=0;n<2;n++)                    //if ch = # then Keep cmm 2 byte(Keep 'OK')
       {
         while(RI==0){;}                ; //Check Flag Rx if RI =1 Have data
         buf_cmm[n] = SBUF              ; //Keep Data 'OK' 
		 RI = 0                         ; //Clear Flag Rx
       }
     
    }while((buf_cmm[0]!='O')&&(buf_cmm[1]!='K')) ; //Check Echo Command = 'OK' Exit Loop
 }


/*******************************************************
 *                  Read Play Time                     *
 *           Buf_Time[0] = Ascii Minute Byte High      *
 *           Buf_Time[1] = Ascii Minute Byte Low       *
 *           Buf_Time[2] = Ascii :                     *
 *           Buf_Time[3] = Ascii Secound Byte High     *
 *           Buf_Time[4] = Ascii Secound Byte Low      *
 *******************************************************/


void RD_Time()
 {
    unsigned char ch,n ;

      do
       {
         while(RI==0){;}                           //Check Flag Rx if RI =1 Have data
         ch = SBUF 				                 ; //Read Data
		 RI = 0                                  ; //Clear Flag Rx
       }while(ch !='@')                          ; //Check Byte Start of Echo cmm('@')

      for(n=0;n<5;n++)                             //if ch = @ then Keep data 5 byte(MM:SS)
       {
         while(RI==0){;}                           //Check Flag Rx if RI =1 Have data
         Buf_Time[n] = SBUF                      ; //Read Data 'MM:SS' 
		 RI = 0                                  ; //Clear Flag Rx
   
       }   
 }


/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 void main(void) 
  {
    unsigned char enter=0x0D  ;


    UART0_Init()      ;
    delay(800)        ;  //delay for Sync Borad MP3 Ready 

    //------------------- Begin Sent Command --------------------
   TI = 1                         ;   //Set Flag TI=1 for Start sent data
   printf("*CF=001%c",enter)      ;   //Sent CMM Config. Play[000] =0:Play Instantly ,0:Play 1 Round ,1: Display Time
   while(TI == 0){;}	               //Check Flag TI=1 Sent data Ready Exit loop 
   TI=0                           ;   //Clear Flag TI
   Echo_Cmm()                     ;   //Check CMM'#OK'

   //------------- Loop Play file by Name -----------
      
   while(1)
     {
	  TI = 1                                 ;   //Set Flag TI=1 for Start sent data
      printf("*P2=A23_FT1.MP3%c",enter)      ;   //Sent CMM Play File by Name : 'A23_FT1.MP3'
      while(TI == 0){;}	                         //Check Flag TI=1 Sent data Ready Exit loop 
      TI=0                                   ;   //Clear Flag TI
	 
	  Echo_Cmm()                             ;   //Check CMM'#OK'
	  
	  do
	  {
	    RD_Time()                            ;  //Read Playing Time    
      }while((Buf_Time[0]!='0')||(Buf_Time[1]!='0')||(Buf_Time[3]!='3')||(Buf_Time[4]!='0'))  ;  //Check Play File to 00.30 sec. Give Chang play File    
	  
	
	  TI = 1                                 ;   //Set Flag TI=1 for Start sent data
      printf("*P2=A24_FT2.MP3%c",enter)      ;   //Sent CMM Play File by Name : 'A24_FT2.MP3'
      while(TI == 0){;}	                         //Check Flag TI=1 Sent data Ready Exit loop 
      TI=0                                   ;   //Clear Flag TI
	
	  Echo_Cmm()                             ;   //Check CMM'#OK'

      do
	  {
	    RD_Time()                            ;   //Read Playing Time   
      }while((Buf_Time[0]!='0')||(Buf_Time[1]!='1')||(Buf_Time[3]!='0')||(Buf_Time[4]!='0'))  ; //Check Play File to 01.00 minit. Give Chang play File      
		
	}  // Return Play File New
  }





